// IsoSurface.h
// Definit l'interface de base des iso-surfaces : f(x,y,z) = 0 (avec chaud (f>0) a l'interieur et froid (f<0) a l'exterieur

#ifndef V3D_BLOBS_ISO_SURFACE_H_INCLUDED
#define V3D_BLOBS_ISO_SURFACE_H_INCLUDED

#include "ScanLines.h"

namespace V3D {


//////////////////////////////////////////////////////////////////////////////////////////

class IsoSurface
{
public:
	IsoSurface() {}
	virtual ~IsoSurface() {}

    // Calcul des normales a l'isosurface (pour un tableau de positions)
	void ComputeSurfaceNormals( Vect3fArray& avNorms, const Vect3DArray& aPos) const;

    // Calcul des normales a l'isosurface (pour un sous-tableau de positions)
	virtual void ComputeSurfaceNormalsSubArray( Vect3fArray& avNorms, const Vect3DArray& aPos,
	                                          int32 nFirstIndex, int32 nNormalsToCompute) const = 0;

    // Evaluation du potentiel au point donne, a usage gnrique des IsoSurface,
	// ATT : Lent !  il vaut mieux calculer les valeurs sur une grille par exemple (fct FuncValuesForPlaneGrid).
	virtual float FuncValueAtPos( const Vector3D& pos) const = 0;

	// Calcul de la boite AABB englobante du volume ou le potentiel n'est pas nul
	virtual bool ComputeBounds( Vector3D& vcBoundMin, Vector3D& vcBoundMax ) const;

	// Determination des cubes a explorer sur une "tranche" de l'espace
	virtual bool FindInterestingPartsOfPlane( AllScansArray& aScansPlane,
											const Vector3D& vcStart, const Vector3D& vcSteps,
											int32 nStepsX, int32 nStepsY) const;
	
	// Calcul des potentiels (isovalues) sur une l'ensemble grille de un cube d'epaisseur
	// le AllScansArray facultatif permet d'accelerer les choses en n'etudiant que la sous-partie
	// potentiellement interessante de la grille (a etablir prealablement)
	virtual void FuncValuesForPlaneGrid( float* pafValues, 
								const Vector3D& vcStart, LengthType fDeltaX, LengthType fDeltaY,
								int32 nStepsX, int32 nStepsY,
								const AllScansArray* paScansCubesToClean = 0 ) const = 0;


protected:
};



//////////////////////////////////////////////////////////////////////////////////////////


} // namespace



#endif	// #ifndef V3D_BLOBS_ISO_SURFACE_H_INCLUDED

